'use strict';

function GroupsModalCtrl($scope, $rootScope){

    $scope.title = 'Utwórz grupę';
    $scope.name = '';
    $scope.group = {};

    $scope.$on('Groups:openGroupModal', function(event, group){
        $scope.openModal();
        $scope.group = group;
        $scope.name = group.name;
        $scope.title = ($scope.group.id == 0) ? 'Utwórz grupę' : 'Edytuj grupę';
    });


    $scope.openModal = function(){
        angular.element('#modal-group-add').modal('show');
    }

    $scope.closeModal = function(){
        angular.element('#modal-group-add').modal('hide');
    }

    $scope.saveGroup = function(){
        $scope.group.name = $scope.name;

        $rootScope.$broadcast('Groups:saveGroup', $scope.group);
        $scope.closeModal();
    }
}

GroupsModalCtrl.$inject = ['$scope', '$rootScope'];